/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.user.service.impl;

import com.tp_link.eap.domain.account.Role;
import com.tp_link.eap.domain.account.RoleType;
import com.tp_link.eap.domain.account.User;
import com.tp_link.eap.domain.global.OperationResult;
import com.tp_link.eap.domain.site.Privilege;
import com.tp_link.eap.domain.ui.QueryFilter;
import com.tp_link.eap.domain.ui.QueryPage;
import com.tp_link.eap.domain.ui.QuerySort;
import com.tp_link.eap.multicontrol.ControlType;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.multicontrol.ResErrorCode;
import com.tp_link.eap.user.b.a;
import com.tp_link.eap.user.repo.UserRepository;
import com.tp_link.eap.user.service.PrivilegeServiceI;
import com.tp_link.eap.user.service.RoleService;
import com.tp_link.eap.user.service.UserService;
import com.tp_link.eap.user.service.impl.UserServiceImpl$1;
import com.tp_link.eap.user.service.impl.UserServiceImpl$2;
import com.tp_link.eap.util.e;
import com.tp_link.eap.util.p.b;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.sf.json.JSONObject;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="userService")
public class UserServiceImpl
extends com.tp_link.eap.i.a.a<User>
implements UserService {
    @Autowired
    private UserRepository a;
    @Autowired
    private PrivilegeServiceI b;
    @Autowired
    private RoleService c;
    private static final Logger d = LoggerFactory.getLogger(UserServiceImpl.class);

    @Override
    public List<User> getAll() {
        List list = com.tp_link.eap.util.a.a.a((Iterable)this.a.findAll());
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    @Override
    public User getUserByName(String name) {
        if (name == null) {
            return null;
        }
        return this.a.findByName(name);
    }

    @Override
    public User getUserByEmail(String email) {
        if (email == null) {
            return null;
        }
        return this.a.findByEmail(com.tp_link.eap.util.a.d((String)email));
    }

    @Override
    public int getUserCounts() {
        return (int)this.a.count();
    }

    @Override
    public OperationResponse addUser(User user) {
        OperationResponse operationResponse = this.b(user);
        if (!operationResponse.success()) {
            return operationResponse;
        }
        if (this.a.count() >= 50L) {
            d.debug("user num {} has reached maximum", (Object)this.a.count());
            return new OperationResponse(ResErrorCode.bD);
        }
        if (this.isUserNameExists(user.getName())) {
            d.warn("User {} already registered.", (Object)user.getName());
            return new OperationResponse(ResErrorCode.cr);
        }
        if (this.isEmailExists(user.getEmail())) {
            d.warn("Email {} already registered.", (Object)user.getEmail());
            return new OperationResponse(ResErrorCode.cs);
        }
        user.setPassword(com.tp_link.eap.user.security.a.c(user.getPassword()));
        Calendar calendar = Calendar.getInstance();
        user.setCreatedTime(calendar.getTime());
        user.setDefault(user.isDefault());
        user.setRoleName(user.getRole().getName());
        user.setLastSite(com.tp_link.eap.d.b.a());
        this.a.save(user);
        this.b.refreshUserPrivileges(user.getName(), null, null, user.getRole());
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"userName", (Object)user.getName());
        return new OperationResponse(ResErrorCode.a, (Object)jSONObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse delUserByName(String name, ControlType controlType) {
        Object object = com.tp_link.eap.b.b.a.a;
        synchronized (object) {
            User user = this.a.findByName(name);
            if (user == null) {
                return new OperationResponse(ResErrorCode.cx, String.format("User %s not exists.", name), null);
            }
            if (this.a(user)) {
                return new OperationResponse(ResErrorCode.cy, String.format("Default user %s can not be deleted.", name), null);
            }
            if (controlType.equals((Object)ControlType.a) || controlType.equals((Object)ControlType.c)) {
                Subject subject = SecurityUtils.getSubject();
                String string = (String)subject.getPrincipal();
                if (string == null) {
                    return new OperationResponse(ResErrorCode.cz);
                }
                if (string.equals(name)) {
                    return new OperationResponse(ResErrorCode.cA, String.format("Currently logged-in user %s can not be deleted.", name), null);
                }
            }
            this.a.delete(user);
            com.tp_link.eap.user.b.a.b(name);
            this.b.deleteUserPrivilege(name);
        }
        return new OperationResponse(ResErrorCode.a, String.format("User %s was deleted.", name), null);
    }

    @Override
    public boolean isAdmin(String name) {
        User user = this.a.findByName(name);
        if (user == null) {
            return false;
        }
        Role role = user.getRole();
        return null != role && role.getName().equals(RoleType.SYSTEM_ADMIN.getTypeName());
    }

    private boolean a(User user) {
        return user.isDefault();
    }

    @Override
    public Role getRoleByUserName(String name) {
        if (name == null) {
            return null;
        }
        User user = this.a.findByName(name);
        if (user == null) {
            return null;
        }
        return user.getRole();
    }

    @Override
    public boolean isUserNameExists(String name) {
        User user = this.a.findByName(name);
        return user != null;
    }

    @Override
    public boolean isEmailExists(String email) {
        if (email != null) {
            User user = this.a.findByEmail(com.tp_link.eap.util.a.d((String)email));
            return user != null;
        }
        return false;
    }

    @Override
    public OperationResponse updateCurrentUser(User user) {
        OperationResponse operationResponse = this.b(user);
        if (!operationResponse.success()) {
            return operationResponse;
        }
        User user2 = this.getUserByName(user.getName());
        if (user2 == null) {
            d.warn("User {} not exists.", (Object)user.getName());
            return new OperationResponse(ResErrorCode.ct);
        }
        if (user.getEmail() != null && !user.getEmail().equals(user2.getEmail()) && this.isEmailExists(user.getEmail())) {
            d.warn("Email {} already registered.", (Object)user.getEmail());
            return new OperationResponse(ResErrorCode.cs);
        }
        if (!user.getPassword().equals("")) {
            user2.setPassword(com.tp_link.eap.user.security.a.c(user.getPassword()));
        }
        user2.setDescription(user.getDescription());
        user2.setEmail(user.getEmail());
        user2.setRole(user.getRole());
        user2.setRoleName(user.getRole().getName());
        this.a.save(user2);
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"userName", (Object)user.getName());
        return new OperationResponse(ResErrorCode.a, (Object)jSONObject);
    }

    @Override
    public OperationResponse updateUser(User user, boolean isResetPassword, ControlType controlType) {
        String string;
        String string2;
        OperationResponse operationResponse = this.b(user);
        if (!operationResponse.success()) {
            return operationResponse;
        }
        User user2 = this.getUserByName(user.getName());
        if (user2 == null) {
            d.warn("User {} not exists.", (Object)user.getName());
            return new OperationResponse(ResErrorCode.ct);
        }
        if ((user2.getEmail() != null && !user2.getEmail().equals(user.getEmail()) || user2.getEmail() == null && user.getEmail() != null) && this.isEmailExists(user.getEmail())) {
            d.warn("Email {} already registered.", (Object)user.getEmail());
            return new OperationResponse(ResErrorCode.cs);
        }
        if (!user.getPassword().equals("")) {
            user2.setPassword(com.tp_link.eap.user.security.a.c(user.getPassword()));
        }
        boolean bl = false;
        if (!isResetPassword) {
            Subject subject;
            string2 = user.getName();
            string = null;
            if ((controlType.equals((Object)ControlType.a) || controlType.equals((Object)ControlType.c)) && (string = (String)(subject = SecurityUtils.getSubject()).getPrincipal()) == null) {
                d.warn("Error occurred while updating user.");
                return new OperationResponse(ResErrorCode.b);
            }
            if (!user2.getRole().getName().equals(user.getRole().getName()) || !user.getPassword().equals("")) {
                com.tp_link.eap.user.b.a.b(string2);
                if (string != null && string2.equals(string)) {
                    bl = true;
                }
            }
        }
        string2 = user2.getRole();
        user2.setDescription(user.getDescription());
        user2.setEmail(user.getEmail());
        user2.setRole(user.getRole());
        user2.setRoleName(user.getRole().getName());
        this.a.save(user2);
        this.b.refreshUserPrivileges(user.getName(), user2.getName(), (Role)string2, user.getRole());
        string = new JSONObject();
        string.put((Object)"sessionRemoved", (Object)bl);
        return new OperationResponse(ResErrorCode.a, (Object)string);
    }

    @Override
    public OperationResult updateUserVerifyInfo(User user) {
        if (user == null) {
            return new OperationResult(false, "Illegal parameter.");
        }
        if (!this.isUserNameExists(user.getName())) {
            return new OperationResult(false, String.format("User %s not exists.", user.getName()));
        }
        User user2 = this.getUserByName(user.getName());
        user2.setVerifyCode(user.getVerifyCode());
        user2.setVerifyOutDate(user.getVerifyOutDate());
        this.a.save(user2);
        return new OperationResult(true, String.format("User %s was updated.", user.getName()));
    }

    @Override
    public String generateResetPasswordUrl(String email) {
        if (!this.isEmailExists(email)) {
            d.warn("Email " + email + " not exists.");
            return null;
        }
        User user = this.getUserByEmail(email);
        String string = this.a(user.getName());
        Date date = this.a();
        user.setVerifyOutDate(date);
        user.setVerifyCode(string);
        this.a.save(user);
        String string2 = "email=" + email + "&c=" + string;
        return String.format(string2, new Object[0]);
    }

    private Date a() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(10, com.tp_link.eap.user.a.b.g);
        return calendar.getTime();
    }

    private String a(String string) {
        String string2 = UUID.randomUUID().toString();
        String string3 = string + ":" + string2;
        return com.tp_link.eap.util.e.a.a((String)string3);
    }

    @Override
    public OperationResult verifyResetPassword(String email, String verifyCode) {
        if (email == null || verifyCode == null) {
            return new OperationResult(false, "The link is invalid");
        }
        User user = this.getUserByEmail(email);
        if (user == null) {
            return new OperationResult(false, "The link is invalid.");
        }
        if (user.getVerifyCode() == null || user.getVerifyOutDate() == null) {
            return new OperationResult(false, "The link is invalid.");
        }
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        if (date.after(user.getVerifyOutDate())) {
            return new OperationResult(false, "The link is out of date.");
        }
        if (!verifyCode.equals(user.getVerifyCode())) {
            return new OperationResult(false, "The link is invalid.");
        }
        return new OperationResult(true, "The link is verified.");
    }

    public List<User> getList(QueryPage queryPage) {
        List<User> list = this.getList(queryPage, null, null, null);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<User> getList(QueryPage queryPage, QuerySort querySort) {
        List<User> list = this.getList(queryPage, querySort, null, null);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<User> getList(QueryPage queryPage, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        List<User> list = this.getList(queryPage, null, filters, searchFilters);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<User> getList(QueryPage queryPage, QuerySort querySort, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        List<User> list = this.a.getByFilters(null, null, filters, searchFilters);
        HashSet<User> hashSet = new HashSet<User>(list);
        List<User> list2 = null;
        if (searchFilters != null && searchFilters.size() > 0) {
            list2 = this.b((String)searchFilters.get(0).getFilterValue());
            for (User user : list2) {
                hashSet.add(user);
            }
        }
        ArrayList<User> arrayList = new ArrayList<User>(hashSet);
        if (querySort == null || querySort.getSortDirection().equals((Object)QuerySort.SortDirection.asc)) {
            Collections.sort(arrayList, new UserServiceImpl$1(this));
        } else {
            Collections.sort(arrayList, new UserServiceImpl$2(this));
        }
        if (queryPage != null) {
            int n;
            int n2 = (n = queryPage.getPage() * queryPage.getSize()) + queryPage.getSize();
            return arrayList.subList(n, n2 > arrayList.size() ? arrayList.size() : n2);
        }
        return arrayList;
    }

    public long count(List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        List<User> list = this.a.getByFilters(null, null, filters, searchFilters);
        HashSet<User> hashSet = new HashSet<User>(list);
        List<User> list2 = null;
        if (searchFilters != null && searchFilters.size() > 0) {
            list2 = this.b((String)searchFilters.get(0).getFilterValue());
            for (User user : list2) {
                hashSet.add(user);
            }
        }
        return hashSet.size();
    }

    private List<User> b(String string) {
        List list = com.tp_link.eap.util.a.a.a((Iterable)this.a.findAll());
        if (list == null) {
            return new ArrayList<User>();
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            User user = (User)iterator.next();
            if (user.getEmail().contains(string)) continue;
            iterator.remove();
        }
        return list;
    }

    private OperationResponse b(User user) {
        if (user == null) {
            return new OperationResponse(ResErrorCode.b);
        }
        if (user.getRole() == null) {
            d.warn("Role not exists for {}.", (Object)user.getName());
            return new OperationResponse(ResErrorCode.cn);
        }
        if (user.getEmail() != null && !com.tp_link.eap.util.p.b.a((String)user.getEmail())) {
            d.warn("Invalid email address {} .", (Object)user.getEmail());
            return new OperationResponse(ResErrorCode.co);
        }
        if (!com.tp_link.eap.util.p.b.a((String)user.getName(), (int)com.tp_link.eap.user.a.b.a, (int)com.tp_link.eap.user.a.b.b)) {
            d.warn("Invalid user name {}.", (Object)user.getName());
            return new OperationResponse(ResErrorCode.cp);
        }
        if (!user.getPassword().equals("") && !com.tp_link.eap.util.p.b.b((String)user.getPassword(), (int)com.tp_link.eap.user.a.b.e, (int)com.tp_link.eap.user.a.b.f)) {
            d.warn("Invalid password for {}.", (Object)user.getName());
            return new OperationResponse(ResErrorCode.cq);
        }
        d.debug("User {} is valid.", (Object)user.getName());
        return e.bd;
    }

    @Override
    public void deleteAllExceptDefault() {
        List<User> list = this.getAll();
        if (!CollectionUtils.isEmpty(list)) {
            for (int i = 0; i < list.size(); ++i) {
                User user = list.get(i);
                if (user.isDefault()) continue;
                this.a.delete(user);
            }
        }
    }

    @Override
    public OperationResult restoreUser(User user) {
        d.debug("restore user: {}", (Object)user.getName());
        if (this.isUserNameExists(user.getName())) {
            return new OperationResult(false, String.format("User %s already registered.", user.getName()));
        }
        if (this.isEmailExists(user.getEmail())) {
            return new OperationResult(false, String.format("Email %s already registered.", user.getEmail()));
        }
        Calendar calendar = Calendar.getInstance();
        user.setCreatedTime(calendar.getTime());
        user.setDefault(user.isDefault());
        user.setRoleName(user.getRole().getName());
        this.a.save(user);
        return e.bc;
    }

    @Override
    public OperationResult resetDefaultUserLastSite() {
        List<User> list = this.getAll();
        if (!CollectionUtils.isEmpty(list)) {
            for (int i = 0; i < list.size(); ++i) {
                User user = list.get(i);
                if (!user.isDefault()) continue;
                user.setLastSite("Default");
                this.a.save(user);
                Privilege privilege = this.b.findPrivilegeByUserNameAndSiteName(user.getName(), user.getLastSite());
                if (null == privilege) {
                    this.b.assignSiteToUser(user.getName(), user.getLastSite(), user.getRole());
                } else {
                    privilege.setRole(user.getRole());
                    this.b.savePrivilege(privilege);
                }
                return e.bc;
            }
        } else {
            return e.bf;
        }
        return e.bc;
    }
}

